(*<*)
\<comment>\<open> ******************************************************************** 
 * Project         : HOL-CSP_Metric_Space - Seeing Processes as a Metric Space
 *
 * Author          : Benoît Ballenghien, Benjamin Puyobro
 *
 * This file       : Power Restriction Space
 *
 * Copyright (c) 2024 Université Paris-Saclay, France
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *
 *     * Neither the name of the copyright holders nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************\<close>
(*>*)

section \<open>Power Restriction Space\<close>

theory  PowerRestrictionSpace
  imports RestrictionSpace
begin



setup \<open>Sign.add_const_constraint (\<^const_name>\<open>dist\<close>, NONE)\<close>
  \<comment> \<open>To be able to use \<^const>\<open>dist\<close> out of the \<^class>\<open>metric_space\<close> class.\<close>

class restriction_space_power = uniformity_dist + open_uniformity + restriction_eq +
  fixes dist_\<delta>       :: \<open>'a itself \<Rightarrow> real\<close>
    and dist_inflate :: \<open>'a itself \<Rightarrow> real\<close>
assumes zero_less_dist_\<delta> [simp] : \<open>0 < dist_\<delta> TYPE('a)\<close>
    and dist_\<delta>_less_one  [simp] : \<open>dist_\<delta> TYPE('a) < 1\<close>
    and zero_less_dist_inflate [simp] : \<open>0 < dist_inflate TYPE('a)\<close>
    and dist_restriction_space_is :
    \<open>dist x y = (INF n \<in> restriction_eq_set x y. dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n)\<close>

setup \<open>Sign.add_const_constraint (\<^const_name>\<open>dist\<close>, SOME \<^typ>\<open>'a :: metric_space \<Rightarrow> 'a \<Rightarrow> real\<close>)\<close>
  \<comment> \<open>Only allow \<^const>\<open>dist\<close> in class \<^class>\<open>metric_space\<close> (back to normal).\<close>

context restriction_space_power
begin


text \<open>Some preliminaries.\<close>

lemma zero_le_dist_inflate [simp] : \<open>0 \<le> dist_inflate TYPE('a)\<close>
  by (simp add: order_less_imp_le)

lemma dist_inflate_not_eq_zero [simp] : \<open>dist_inflate TYPE('a) \<noteq> 0\<close>
  using zero_less_dist_inflate by linarith


lemma zero_le_dist_\<delta>   [simp] : \<open>0 \<le> dist_\<delta> TYPE('a)\<close>
  and    dist_\<delta>_le_one [simp] : \<open>dist_\<delta> TYPE('a) \<le> 1\<close>
  by (simp add: order_less_imp_le) 
     (simp add: dual_order.order_iff_strict)

lemma dist_\<delta>_not_eq_zero [simp] : \<open>dist_\<delta> TYPE('a) \<noteq> 0\<close>
  using zero_less_dist_\<delta> by linarith

lemma power_dist_\<delta>_le_one [simp] : \<open>dist_\<delta> TYPE('a) ^ n \<le> 1\<close>
  by (meson dist_\<delta>_less_one dual_order.strict_iff_not power_le_one zero_less_dist_\<delta>)

lemma dist_\<delta>_power_inject [simp] : \<open>dist_\<delta> TYPE('a) ^ n = dist_\<delta> TYPE('a) ^ m \<longleftrightarrow> n = m\<close>
  by (metis dist_\<delta>_less_one nle_le power_decreasing_iff zero_less_dist_\<delta>)

lemma dist_\<delta>_power_eq_one_iff [simp] : \<open>dist_\<delta> TYPE('a) ^ n = 1 \<longleftrightarrow> n = 0\<close>
  by (metis dist_\<delta>_power_inject power_0)

lemma antimono_power_dist_\<delta> : \<open>antimono (\<lambda>n. dist_\<delta> TYPE('a) ^ n)\<close> by (simp add: antimonoI)

lemma dist_\<delta>_power_inject_base :
  \<open>\<lbrakk>0 < \<delta>'; \<delta>' < 1; dist_\<delta> TYPE('a) ^ Suc n = \<delta>' ^ Suc n\<rbrakk> \<Longrightarrow> dist_\<delta> TYPE('a) = \<delta>'\<close>
  by (meson less_eq_real_def power_inject_base zero_le_dist_\<delta>)



text \<open>Some nice properties before the proof obligation.\<close>

abbreviation power_restriction_eq_set :: \<open>'a \<Rightarrow> 'a \<Rightarrow> real set\<close>
  where \<open>power_restriction_eq_set x y \<equiv>
         {dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n| n. n \<in> restriction_eq_set x y}\<close>
         

lemma power_restriction_eq_set_alt :
  \<open>power_restriction_eq_set x y =
   (*) (dist_inflate TYPE('a)) ` (^) (dist_\<delta> TYPE('a)) ` restriction_eq_set x y\<close>
  by blast

lemma dist_restriction_space_def : \<open>dist x y = Inf (power_restriction_eq_set x y)\<close>
  by (simp add: dist_restriction_space_is setcompr_eq_image)


lemma power_restriction_eq_set_commute :
  \<open>power_restriction_eq_set x y = power_restriction_eq_set y x\<close> by auto

lemma nonempty_power_restriction_eq_set: \<open>power_restriction_eq_set x y \<noteq> {}\<close>
  using nonempty_restriction_eq_set by auto

lemma power_restriction_eq_set_subset_interval_0_dist_\<delta>:
  \<open>power_restriction_eq_set x y \<subseteq> {0..dist_inflate TYPE('a)}\<close> by auto

lemma bounded_power_restriction_eq_set: \<open>bounded (power_restriction_eq_set x y)\<close>
proof -
  have \<open>power_restriction_eq_set x y \<subseteq> ball 0 (dist_inflate TYPE('a) + 1)\<close>
    by (rule subset_trans[OF power_restriction_eq_set_subset_interval_0_dist_\<delta>])
       (simp add: atLeastAtMost_eq_cball subset_iff dist_real_def abs_real_def)
  thus \<open>bounded (power_restriction_eq_set x y)\<close> by (rule bounded_subset_ballI)
qed


corollary dist_restriction_space_Inf_properties:
  \<open>a \<in> power_restriction_eq_set x y \<Longrightarrow> dist x y \<le> a\<close>
  \<open>\<lbrakk>\<And>a. a \<in> power_restriction_eq_set x y \<Longrightarrow> b \<le> a\<rbrakk> \<Longrightarrow> b \<le> dist x y\<close>
  by (unfold dist_restriction_space_def[of x y])
     (erule bounded_has_Inf[OF bounded_power_restriction_eq_set
                               nonempty_power_restriction_eq_set, rule_format])+
   

lemma not_eq_imp_dist_restriction_space_is_dist_inflate_times_pow_of_dist_\<delta>:
  \<open>\<exists>!n. dist x y = dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n \<and>
        x \<down> Suc n \<noteq> y \<down> Suc n \<and> (\<forall>m\<le>n. x \<down> m = y \<down> m)\<close> if \<open>x \<noteq> y\<close>
proof -
  from not_le_imp_ex_not_restriction_eq[OF \<open>x \<noteq> y\<close>] less_Suc_eq_le
  obtain n where * : \<open>x \<down> Suc n \<noteq> y \<down> Suc n\<close> \<open>\<forall>m\<le>n. x \<down> m = y \<down> m\<close> by auto
  have \<open>dist x y = dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n\<close>
  proof (subst eq_iff, rule conjI)
    show \<open>dist x y \<le> dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n\<close>
      by (rule dist_restriction_space_Inf_properties(1))
         (simp add: image_iff "*"(2))
  next
    show \<open>dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n \<le> dist x y\<close>
      by (rule dist_restriction_space_Inf_properties(2), auto simp add: image_iff)
         (use "*" restriction_eq_le not_less_eq_eq in blast)
  qed
  with "*" show \<open>\<exists>!n. dist x y = dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n \<and>
                      x \<down> Suc n \<noteq> y \<down> Suc n \<and> (\<forall>m\<le>n. x \<down> m = y \<down> m)\<close>
    by auto
qed


lemma dist_restriction_space_le_some_dist_inflate_times_pow_of_dist_\<delta>_iff_eq_at_restriction:
  \<open>dist x y \<le> dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n \<longleftrightarrow> x \<down> n = y \<down> n\<close>
proof (rule iffI)
  show \<open>x \<down> n = y \<down> n\<close> if \<open>dist x y \<le> dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n\<close>
  proof (cases \<open>x = y\<close>)
    show \<open>x = y \<Longrightarrow> x \<down> n = y \<down> n\<close> by simp
  next
    from that show \<open>x \<noteq> y \<Longrightarrow> x \<down> n = y \<down> n\<close>
      by (metis dist_\<delta>_less_one zero_less_dist_\<delta> zero_less_dist_inflate mult_le_cancel_left_pos
          not_eq_imp_dist_restriction_space_is_dist_inflate_times_pow_of_dist_\<delta> power_decreasing_iff)
  qed    
next
  show \<open>x \<down> n = y \<down> n \<Longrightarrow> dist x y \<le> dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n\<close>
    by (rule dist_restriction_space_Inf_properties) blast
qed


text \<open>And now, this is a subclass !\<close>

subclass ultrametric_space
proof (unfold_locales)
  have dist_restriction_space_pos: \<open>0 \<le> dist x y\<close> for x y
    by (rule dist_restriction_space_Inf_properties(2)) auto
    
  show dist_restriction_space_0_iff_eq : \<open>dist x y = 0 \<longleftrightarrow> x = y\<close> for x y
  proof (rule iffI)
    assume \<open>dist x y = 0\<close>
    hence \<open>dist x y \<noteq> dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n\<close> for n by simp
    thus \<open>x = y\<close> by (meson not_eq_imp_dist_restriction_space_is_dist_inflate_times_pow_of_dist_\<delta>)
  next
    assume \<open>x = y\<close>
    show \<open>dist x y = 0\<close>
    proof (subst eq_iff, intro conjI)
      show \<open>0 \<le> dist x y\<close> by (fact dist_restriction_space_pos)
    next
      define \<Delta> where \<open>\<Delta> n \<equiv> - (dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n)\<close> for n
      have * : \<open>\<Delta> n \<le> - dist x y\<close> for n
        unfolding \<Delta>_def \<open>x = y\<close>
        using dist_restriction_space_le_some_dist_inflate_times_pow_of_dist_\<delta>_iff_eq_at_restriction by simp
      from LIMSEQ_realpow_zero[of \<open>dist_\<delta> TYPE('a)\<close>, simplified] tendsto_minus_cancel_left
      have \<open>\<Delta> \<longlonglongrightarrow> 0\<close> unfolding \<Delta>_def by force
      from lim_le[OF convergentI[OF \<open>\<Delta> \<longlonglongrightarrow> 0\<close>] "*"] limI[OF \<open>\<Delta> \<longlonglongrightarrow> 0\<close>]
      show \<open>dist x y \<le> 0\<close> by simp
    qed
  qed

  fix x y z :: 'a
  consider \<open>x \<noteq> y\<close> \<open>y \<noteq> z\<close> \<open>x \<noteq> z\<close> | \<open>x = y \<or> y = z \<or> x = z\<close> by blast
  thus \<open>dist x y \<le> max (dist x z) (dist y z)\<close>
  proof cases
    assume \<open>x \<noteq> y\<close> and \<open>y \<noteq> z\<close> and \<open>x \<noteq> z\<close>
    from this[THEN not_eq_imp_dist_restriction_space_is_dist_inflate_times_pow_of_dist_\<delta>] obtain l m n
      where   * : \<open>dist x y = dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ l\<close> \<open>x \<down> Suc l \<noteq> y \<down> Suc l\<close>
        and  ** : \<open>dist y z = dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ m\<close> \<open>\<forall>k\<le>m. y \<down> k = z \<down> k\<close>
        and *** : \<open>dist x z = dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n\<close> \<open>\<forall>k\<le>n. x \<down> k = z \<down> k\<close>
      by auto
    have \<open>min n m \<le> l\<close>
    proof (rule ccontr)
      assume \<open>\<not> min n m \<le> l\<close>
      hence \<open>Suc l \<le> n\<close> and \<open>Suc l \<le> m\<close> by simp_all
      with "**"(2) "***"(2) Suc_le_lessD
      have \<open>x \<down> Suc l = z \<down> Suc l\<close> \<open>y \<down> Suc l = z \<down> Suc l\<close> by simp_all
      hence \<open>x \<down> Suc l = y \<down> Suc l\<close> by simp
      with \<open>x \<down> Suc l \<noteq> y \<down> Suc l\<close> show False by simp
    qed
    hence \<open>dist_\<delta> TYPE('a) ^ l \<le> dist_\<delta> TYPE('a) ^ min n m\<close> by (rule power_decreasing) simp_all
    hence \<open>dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ l
           \<le> dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ min n m\<close> by simp
    with "*"(1) "**"(1) "***"(1)
    show \<open>dist x y \<le> max (dist x z) (dist y z)\<close> by linarith
  next
    show \<open>x = y \<or> y = z \<or> x = z \<Longrightarrow> dist x y \<le> max (dist x z) (dist y z)\<close>
      by (elim disjE; simp add: dist_restriction_space_0_iff_eq[THEN iffD2, OF refl] dist_restriction_space_pos)
         (simp add: dist_restriction_space_def restriction_eq_set_commute setcompr_eq_image)
  qed
  note ultrametric_dist_restriction_space_triangle = this
qed

end


setup \<open>Sign.add_const_constraint (\<^const_name>\<open>restriction\<close>, SOME \<^typ>\<open>'a :: restriction_space \<Rightarrow> nat \<Rightarrow> 'a\<close>)\<close>
  \<comment> \<open>Only allow \<^term>\<open>x \<down> n\<close> in class \<^class>\<open>restriction_space\<close>.\<close>


lemma ex_dist_inflate_times_power_of_dist_\<delta>_less_nonnegative:
  \<open>\<exists>n. dist_inflate TYPE('a :: restriction_space) * dist_\<delta> TYPE('a) ^ n < \<epsilon>\<close> if \<open>0 < \<epsilon>\<close>
proof -
  from \<open>0 < \<epsilon>\<close> have \<open>0 < \<epsilon> / dist_inflate TYPE('a)\<close> by simp
  from real_arch_pow_inv[OF this dist_\<delta>_less_one] obtain n
    where \<open>dist_\<delta> TYPE('a) ^ n < \<epsilon> / dist_inflate TYPE('a)\<close> ..
  hence \<open>dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n < \<epsilon>\<close>
    by (simp add: less_divide_eq mult.commute)
  thus \<open>\<exists>n. dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ n < \<epsilon>\<close> by blast
qed


lemma restriction_tendsto_self: \<open>(\<lambda>n. x \<down> n) \<longlonglongrightarrow> x\<close>
proof (unfold lim_sequentially, intro allI impI)
  fix \<epsilon> :: real
  assume \<open>0 < \<epsilon>\<close>
  from ex_dist_inflate_times_power_of_dist_\<delta>_less_nonnegative[OF \<open>0 < \<epsilon>\<close>] obtain N
    where \<open>dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ N < \<epsilon>\<close> ..
  have \<open>N \<le> n \<Longrightarrow> dist (x \<down> n) x \<le> dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ N\<close> for n
    by (rule dist_restriction_space_Inf_properties(1)) simp
  with \<open>dist_inflate TYPE('a) * dist_\<delta> TYPE('a) ^ N < \<epsilon>\<close>
  have \<open>N \<le> n \<Longrightarrow> dist (x \<down> n) x < \<epsilon>\<close> for n by (meson dual_order.strict_trans2)
  thus \<open>\<exists>N. \<forall>n\<ge>N. dist (x \<down> n) x < \<epsilon>\<close> by blast
qed